<?php
declare(strict_types=1);
require_once __DIR__ . '/../includes/auth.php';
require_once __DIR__ . '/../includes/db.php';
require_once __DIR__ . '/../includes/helpers.php';
init_storage(); require_login();

$servers = load_servers();
$clients = load_clients();
$msg='';

function server_by_id(array $servers, string $id): ?array {
  return find_first($servers, fn($s)=> (string)($s['id']??'')===$id);
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $action=(string)($_POST['action']??'');
  if ($action==='add') {
    $name=trim((string)($_POST['name']??''));
    $user=trim((string)($_POST['username']??''));
    $pass=trim((string)($_POST['password']??''));
    $sid=(string)($_POST['server_id']??'');
    if ($name===''||$user===''||$pass===''||$sid==='') $msg="Preencha tudo.";
    else if (find_first($clients, fn($c)=>(string)($c['username']??'')===$user)) $msg="Username já existe.";
    else { $clients[]=["id"=>"c_".bin2hex(random_bytes(6)),"name"=>$name,"username"=>$user,"password"=>$pass,"server_id"=>$sid,"active"=>true,"created_at"=>time()]; save_clients($clients); $msg="Cliente adicionado."; }
  }
  if ($action==='toggle') {
    $id=(string)($_POST['id']??'');
    update_first($clients, fn($c)=>(string)$c['id']===$id, function($c){$c['active']=!($c['active']??true); return $c;});
    save_clients($clients); $msg="Status atualizado.";
  }
  if ($action==='move_server') {
    $id=(string)($_POST['id']??''); $sid=(string)($_POST['server_id']??'');
    update_first($clients, fn($c)=>(string)$c['id']===$id, function($c) use($sid){$c['server_id']=$sid; return $c;});
    save_clients($clients); $msg="Servidor alterado.";
  }
  if ($action==='delete') {
    $id=(string)($_POST['id']??'');
    delete_first($clients, fn($c)=>(string)$c['id']===$id);
    save_clients($clients); $msg="Cliente removido.";
  }
  if ($action==='bulk_move') {
    $from=(string)($_POST['from_server']??''); $to=(string)($_POST['to_server']??'');
    foreach($clients as $i=>$c){ if((string)($c['server_id']??'')===$from) $clients[$i]['server_id']=$to; }
    save_clients($clients); $msg="Migração em lote concluída.";
  }
}
?>
<!doctype html><html lang="pt-br"><head>
<meta charset="utf-8"><meta name="viewport" content="width=device-width,initial-scale=1">
<title>Clientes</title>
<link rel="stylesheet" href="/panel/admin/assets/style.css">
</head><body>
<div class="container">
  <div class="topbar">
    <div class="brand"><b>Clientes</b><span class="muted">Cada cliente aponta para um servidor (subdomínio).</span></div>
    <div class="nav">
      <a class="btn" href="/panel/admin/dashboard.php">Dashboard</a>
      <a class="btn" href="/panel/admin/servers.php">Servidores</a>
      <a class="btn danger" href="/panel/admin/logout.php">Sair</a>
    </div>
  </div>

  <?php if($msg): ?><div class="notice" style="margin-top:14px;"><?= h($msg) ?></div><?php endif; ?>

  <div class="grid cols-2">
    <div class="card">
      <h2>Novo cliente</h2>
      <form method="post">
        <input type="hidden" name="action" value="add">
        <label>Nome</label><input name="name" required>
        <label>Username</label><input name="username" required>
        <label>Password</label><input name="password" required>
        <label>Servidor</label>
        <select name="server_id" required>
          <option value="">Selecione...</option>
          <?php foreach($servers as $s): ?><option value="<?= h((string)$s['id']) ?>"><?= h((string)$s['name']) ?> — <?= h((string)$s['subdomain']) ?></option><?php endforeach; ?>
        </select>
        <div style="margin-top:12px;"><button class="btn primary" type="submit">Salvar</button></div>
      </form>

      <hr>
      <h2>Migrar em lote</h2>
      <form method="post">
        <input type="hidden" name="action" value="bulk_move">
        <label>De</label><select name="from_server" required><option value="">Selecione...</option><?php foreach($servers as $s): ?><option value="<?= h((string)$s['id']) ?>"><?= h((string)$s['name']) ?> — <?= h((string)$s['subdomain']) ?></option><?php endforeach; ?></select>
        <label>Para</label><select name="to_server" required><option value="">Selecione...</option><?php foreach($servers as $s): ?><option value="<?= h((string)$s['id']) ?>"><?= h((string)$s['name']) ?> — <?= h((string)$s['subdomain']) ?></option><?php endforeach; ?></select>
        <div style="margin-top:12px;"><button class="btn primary" type="submit" onclick="return confirm('Migrar todos?');">Migrar</button></div>
      </form>
    </div>

    <div class="card">
      <h2>Lista</h2>
      <table><thead><tr><th>Nome</th><th>Username</th><th>Servidor</th><th>Status</th><th>Links</th><th>Ações</th></tr></thead><tbody>
      <?php foreach($clients as $c):
        $srv = server_by_id($servers, (string)$c['server_id']);
        $sub = $srv ? (string)$srv['subdomain'] : '';
        $u=(string)$c['username']; $p=(string)$c['password'];
        $m3u = $srv ? ("http://{$sub}/get.php?username=".urlencode($u)."&password=".urlencode($p)."&type=m3u_plus&output=mpegts") : '';
        $epg = $srv ? ("http://{$sub}/xmltv.php?username=".urlencode($u)."&password=".urlencode($p)) : '';
      ?>
        <tr>
          <td><?= h((string)$c['name']) ?></td>
          <td><code><?= h($u) ?></code></td>
          <td><code><?= h($sub ?: '—') ?></code></td>
          <td><?= ($c['active']??true)?'<span class="badge on">Ativo</span>':'<span class="badge off">Inativo</span>' ?></td>
          <td>
            <?php if($srv): ?>
              <div class="muted">M3U:</div><code style="font-size:12px;word-break:break-all;"><?= h($m3u) ?></code>
              <div class="muted" style="margin-top:6px;">EPG:</div><code style="font-size:12px;word-break:break-all;"><?= h($epg) ?></code>
            <?php else: ?><span class="muted">Servidor não encontrado</span><?php endif; ?>
          </td>
          <td class="row-actions">
            <form method="post" style="display:inline"><input type="hidden" name="action" value="toggle"><input type="hidden" name="id" value="<?= h((string)$c['id']) ?>"><button class="btn" type="submit">Ativar/Desativar</button></form>
            <form method="post" style="display:inline">
              <input type="hidden" name="action" value="move_server"><input type="hidden" name="id" value="<?= h((string)$c['id']) ?>">
              <select name="server_id" onchange="this.form.submit()" style="width:220px">
                <?php foreach($servers as $s): ?><option value="<?= h((string)$s['id']) ?>" <?= ((string)$c['server_id']===(string)$s['id'])?'selected':'' ?>><?= h((string)$s['name']) ?> — <?= h((string)$s['subdomain']) ?></option><?php endforeach; ?>
              </select>
            </form>
            <form method="post" style="display:inline" onsubmit="return confirm('Excluir?');"><input type="hidden" name="action" value="delete"><input type="hidden" name="id" value="<?= h((string)$c['id']) ?>"><button class="btn danger" type="submit">Excluir</button></form>
          </td>
        </tr>
      <?php endforeach; ?>
      </tbody></table>
    </div>
  </div>
</div>
</body></html>
