<?php
declare(strict_types=1);
require_once __DIR__ . '/../includes/auth.php';
require_once __DIR__ . '/../includes/db.php';
require_once __DIR__ . '/../includes/helpers.php';
init_storage(); require_login();

$servers = load_servers();
$clients = load_clients();
$activeServers = array_values(array_filter($servers, fn($s) => ($s['active'] ?? true)));
$activeClients = array_values(array_filter($clients, fn($c) => ($c['active'] ?? false)));

$panelBase = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' ? 'https' : 'http') . '://' . ($_SERVER['HTTP_HOST'] ?? 'localhost');
?>
<!doctype html><html lang="pt-br"><head>
<meta charset="utf-8"><meta name="viewport" content="width=device-width,initial-scale=1">
<title>Dashboard</title>
<link rel="stylesheet" href="/panel/admin/assets/style.css">
</head><body>
<div class="container">
  <div class="topbar">
    <div class="brand"><b>Painel Central</b><span class="muted"><?= h($panelBase) ?>/panel</span></div>
    <div class="nav">
      <a class="btn" href="/panel/admin/servers.php">Servidores</a>
      <a class="btn" href="/panel/admin/clients.php">Clientes</a>
      <a class="btn" href="/panel/admin/settings.php">Config</a>
      <a class="btn danger" href="/panel/admin/logout.php">Sair</a>
    </div>
  </div>

  <div class="grid cols-2">
    <div class="card">
      <h2>Resumo</h2>
      <p class="muted">Servidores ativos: <b><?= count($activeServers) ?></b></p>
      <p class="muted">Clientes ativos: <b><?= count($activeClients) ?></b> / Total: <b><?= count($clients) ?></b></p>
      <hr>
      <p class="muted">Exemplo de uso (por servidor):</p>
      <div class="notice">
        <code>http://srv1.seudominio.com/get.php?username=USER&password=PASS&type=m3u_plus&output=mpegts</code><br>
        <code>http://srv1.seudominio.com/xmltv.php?username=USER&password=PASS</code>
      </div>
    </div>
    <div class="card">
      <h2>EDGE Auto-install</h2>
      <ul class="muted" style="line-height:1.7">
        <li>Você sobe o mesmo pacote EDGE em todos subdomínios.</li>
        <li>Ao abrir o subdomínio pela 1ª vez, ele pede URL do Painel e o Secret.</li>
        <li>Ele detecta automaticamente a key pelo host (srv1, srv2...).</li>
      </ul>
    </div>
  </div>
</div>
</body></html>
