<?php
declare(strict_types=1);
require_once __DIR__ . '/../includes/auth.php';
require_once __DIR__ . '/../includes/db.php';
require_once __DIR__ . '/../includes/helpers.php';
init_storage();

$users = load_users();
$hasUser = count($users) > 0;
$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $username = trim((string)($_POST['username'] ?? ''));
  $password = (string)($_POST['password'] ?? '');
  if ($hasUser) {
    if (login_attempt($username, $password)) { header("Location: /panel/admin/dashboard.php"); exit; }
    $error = "Usuário ou senha inválidos.";
  } else {
    if ($username === '' || strlen($password) < 6) $error = "Crie um usuário e senha (mín. 6).";
    else {
      $users[] = [
        "id" => "u_" . bin2hex(random_bytes(6)),
        "username" => $username,
        "password_hash" => password_hash($password, PASSWORD_DEFAULT),
        "created_at" => time()
      ];
      save_users($users);
      login_attempt($username, $password);
      header("Location: /panel/admin/dashboard.php"); exit;
    }
  }
}
?>
<!doctype html><html lang="pt-br"><head>
<meta charset="utf-8"><meta name="viewport" content="width=device-width,initial-scale=1">
<title>Login - Painel</title>
<link rel="stylesheet" href="/panel/admin/assets/style.css">
</head><body>
<div class="container" style="max-width:520px; padding-top:40px;">
  <div class="card">
    <h2><?= $hasUser ? "Entrar" : "Criar usuário admin (1ª vez)" ?></h2>
    <p class="muted">Depois você cria servidores (srv1, srv2...) e clientes.</p>
    <?php if ($error): ?><div class="notice" style="border-color:rgba(251,113,133,.45); background:rgba(251,113,133,.10);"><?= h($error) ?></div><?php endif; ?>
    <form method="post">
      <label>Usuário</label><input name="username" required>
      <label>Senha</label><input name="password" type="password" required>
      <div style="margin-top:14px;"><button class="btn primary" type="submit"><?= $hasUser ? "Entrar" : "Criar e Entrar" ?></button></div>
    </form>
  </div>
</div>
</body></html>
