<?php
declare(strict_types=1);
require_once __DIR__ . '/../includes/auth.php';
require_once __DIR__ . '/../includes/db.php';
require_once __DIR__ . '/../includes/helpers.php';
init_storage(); require_login();

$config = require dirname(__DIR__) . '/config.php';
$servers = load_servers();
$msg = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $action = (string)($_POST['action'] ?? '');
  if ($action === 'add') {
    $name = trim((string)($_POST['name'] ?? ''));
    $key  = trim((string)($_POST['key'] ?? ''));
    $sub  = trim((string)($_POST['subdomain'] ?? ''));
    $base = trim((string)($_POST['base_url'] ?? ''));
    $ttl  = (int)($_POST['cache_ttl'] ?? ($config['default_playlist_cache_ttl'] ?? 60));
    $epg  = (int)($_POST['epg_cache_ttl'] ?? ($config['default_epg_cache_ttl'] ?? 3600));
    $api  = (int)($_POST['api_cache_ttl'] ?? ($config['default_api_cache_ttl'] ?? 30));

    if ($name===''||$key===''||$sub===''||$base==='') $msg="Preencha tudo.";
    else if (find_first($servers, fn($s)=> (string)($s['key']??'')===$key)) $msg="Key já existe.";
    else {
      $servers[] = [
        "id" => "s_" . bin2hex(random_bytes(5)),
        "name"=>$name,"key"=>$key,"subdomain"=>$sub,"base_url"=>$base,
        "cache_ttl"=>max(10,$ttl),"epg_cache_ttl"=>max(60,$epg),"api_cache_ttl"=>max(5,$api),
        "active"=>true,"created_at"=>time()
      ];
      save_servers($servers); $msg="Servidor adicionado.";
    }
  }
  if ($action==='toggle') {
    $id=(string)($_POST['id']??'');
    update_first($servers, fn($s)=>(string)$s['id']===$id, function($s){ $s['active']=!($s['active']??true); return $s;});
    save_servers($servers); $msg="Status atualizado.";
  }
  if ($action==='delete') {
    $id=(string)($_POST['id']??'');
    delete_first($servers, fn($s)=>(string)$s['id']===$id);
    save_servers($servers); $msg="Servidor removido.";
  }
}
?>
<!doctype html><html lang="pt-br"><head>
<meta charset="utf-8"><meta name="viewport" content="width=device-width,initial-scale=1">
<title>Servidores</title>
<link rel="stylesheet" href="/panel/admin/assets/style.css">
</head><body>
<div class="container">
  <div class="topbar">
    <div class="brand"><b>Servidores</b><span class="muted">Key (srv1) + subdomínio + base_url.</span></div>
    <div class="nav">
      <a class="btn" href="/panel/admin/dashboard.php">Dashboard</a>
      <a class="btn" href="/panel/admin/clients.php">Clientes</a>
      <a class="btn danger" href="/panel/admin/logout.php">Sair</a>
    </div>
  </div>

  <?php if($msg): ?><div class="notice" style="margin-top:14px;"><?= h($msg) ?></div><?php endif; ?>

  <div class="grid cols-2">
    <div class="card">
      <h2>Novo servidor</h2>
      <form method="post">
        <input type="hidden" name="action" value="add">
        <label>Nome</label><input name="name" placeholder="Servidor 1" required>
        <label>Key</label><input name="key" placeholder="srv1" required>
        <label>Subdomínio</label><input name="subdomain" placeholder="srv1.appps.top" required>
        <label>Base URL</label><input name="base_url" placeholder="http://zeroum.blog:80" required>
        <div class="grid cols-2" style="margin-top:10px;">
          <div><label>Cache Playlist (s)</label><input name="cache_ttl" type="number" value="<?= h((string)($config['default_playlist_cache_ttl']??60)) ?>"></div>
          <div><label>Cache EPG (s)</label><input name="epg_cache_ttl" type="number" value="<?= h((string)($config['default_epg_cache_ttl']??3600)) ?>"></div>
        </div>
        <label>Cache API (s)</label><input name="api_cache_ttl" type="number" value="<?= h((string)($config['default_api_cache_ttl']??30)) ?>">
        <div style="margin-top:12px;"><button class="btn primary" type="submit">Salvar</button></div>
      </form>
    </div>

    <div class="card">
      <h2>Lista</h2>
      <table><thead><tr><th>Key</th><th>Subdomínio</th><th>Base</th><th>Status</th><th>Ações</th></tr></thead><tbody>
      <?php foreach($servers as $s): ?>
        <tr>
          <td><code><?= h((string)$s['key']) ?></code></td>
          <td><code><?= h((string)$s['subdomain']) ?></code></td>
          <td><code><?= h((string)$s['base_url']) ?></code></td>
          <td><?= ($s['active']??true)?'<span class="badge on">Ativo</span>':'<span class="badge off">Inativo</span>' ?></td>
          <td class="row-actions">
            <form method="post" style="display:inline"><input type="hidden" name="action" value="toggle"><input type="hidden" name="id" value="<?= h((string)$s['id']) ?>"><button class="btn" type="submit">Ativar/Desativar</button></form>
            <form method="post" style="display:inline" onsubmit="return confirm('Remover servidor?');"><input type="hidden" name="action" value="delete"><input type="hidden" name="id" value="<?= h((string)$s['id']) ?>"><button class="btn danger" type="submit">Excluir</button></form>
          </td>
        </tr>
      <?php endforeach; ?>
      </tbody></table>
    </div>
  </div>
</div>
</body></html>
