<?php
declare(strict_types=1);
require_once __DIR__ . '/../includes/auth.php';
require_once __DIR__ . '/../includes/db.php';
require_once __DIR__ . '/../includes/helpers.php';
init_storage(); require_login();

$msg='';
$users=load_users(); $me=current_user();
if ($_SERVER['REQUEST_METHOD']==='POST'){
  $new=(string)($_POST['new_password']??'');
  if(strlen($new)<6) $msg="Senha mínima 6.";
  else{
    update_first($users, fn($u)=>(string)($u['id']??'')===(string)($me['id']??''), function($u) use($new){$u['password_hash']=password_hash($new,PASSWORD_DEFAULT); return $u;});
    save_users($users); $msg="Senha alterada.";
  }
}
?>
<!doctype html><html lang="pt-br"><head>
<meta charset="utf-8"><meta name="viewport" content="width=device-width,initial-scale=1">
<title>Config</title><link rel="stylesheet" href="/panel/admin/assets/style.css">
</head><body><div class="container">
  <div class="topbar">
    <div class="brand"><b>Configurações</b><span class="muted">Secret do EDGE</span></div>
    <div class="nav">
      <a class="btn" href="/panel/admin/dashboard.php">Dashboard</a>
      <a class="btn" href="/panel/admin/clients.php">Clientes</a>
      <a class="btn danger" href="/panel/admin/logout.php">Sair</a>
    </div>
  </div>
  <?php if($msg): ?><div class="notice" style="margin-top:14px;"><?= h($msg) ?></div><?php endif; ?>
  <div class="grid cols-2">
    <div class="card">
      <h2>Trocar senha</h2>
      <form method="post">
        <label>Nova senha</label><input type="password" name="new_password" required>
        <div style="margin-top:12px;"><button class="btn primary" type="submit">Salvar</button></div>
      </form>
    </div>
    <div class="card">
      <h2>Shared Secret (use no instalador EDGE)</h2>
      <p class="muted">Cole esse secret ao instalar cada subdomínio (1ª vez).</p>
      <div class="notice"><code>3d90437b78bc88da1a5307dd4d19f69342774ad908d74e43</code></div>
    </div>
  </div>
</div></body></html>
