<?php
declare(strict_types=1);
require_once __DIR__ . '/includes/db.php';
require_once __DIR__ . '/includes/helpers.php';

init_storage();
$config = require __DIR__ . '/config.php';
$secret = (string)($config['edge_shared_secret'] ?? '');

$provided = (string)($_GET['secret'] ?? '');
if ($secret === '' || !hash_equals($secret, $provided)) {
  http_response_code(403);
  header('Content-Type: application/json; charset=UTF-8');
  echo json_encode(["ok"=>false,"error"=>"forbidden"]);
  exit;
}

$server_key = trim((string)($_GET['server_key'] ?? ''));
$username = (string)($_GET['username'] ?? '');
$password = (string)($_GET['password'] ?? '');

if ($server_key === '' || $username === '' || $password === '') {
  http_response_code(400);
  header('Content-Type: application/json; charset=UTF-8');
  echo json_encode(["ok"=>false,"error"=>"missing_params"]);
  exit;
}

$servers = load_servers();
$clients = load_clients();

$server = find_first($servers, fn($s) => (string)($s['key'] ?? '') === $server_key && ($s['active'] ?? true));
if (!$server) {
  http_response_code(404);
  header('Content-Type: application/json; charset=UTF-8');
  echo json_encode(["ok"=>false,"error"=>"server_not_found"]);
  exit;
}

$client = find_first($clients, fn($c) =>
  ($c['active'] ?? false) &&
  (string)($c['username'] ?? '') === $username &&
  (string)($c['password'] ?? '') === $password
);

if (!$client) {
  http_response_code(403);
  header('Content-Type: application/json; charset=UTF-8');
  echo json_encode(["ok"=>false,"error"=>"invalid_credentials"]);
  exit;
}

if ((string)($client['server_id'] ?? '') !== (string)($server['id'] ?? '')) {
  http_response_code(403);
  header('Content-Type: application/json; charset=UTF-8');
  echo json_encode(["ok"=>false,"error"=>"client_not_in_this_server"]);
  exit;
}

$base = rtrim((string)($server['base_url'] ?? ''), '/');
if ($base === '') {
  http_response_code(502);
  header('Content-Type: application/json; charset=UTF-8');
  echo json_encode(["ok"=>false,"error"=>"server_base_missing"]);
  exit;
}

header('Content-Type: application/json; charset=UTF-8');
echo json_encode([
  "ok" => true,
  "server" => [
    "id" => $server['id'],
    "key" => $server['key'],
    "name" => $server['name'],
    "base_url" => $base,
    "cache_ttl" => (int)($server['cache_ttl'] ?? ($config['default_playlist_cache_ttl'] ?? 60)),
    "epg_cache_ttl" => (int)($server['epg_cache_ttl'] ?? ($config['default_epg_cache_ttl'] ?? 3600)),
    "api_cache_ttl" => (int)($server['api_cache_ttl'] ?? ($config['default_api_cache_ttl'] ?? 30)),
  ],
], JSON_UNESCAPED_SLASHES);
