<?php
declare(strict_types=1);
require_once __DIR__ . '/db.php';

session_start();

function is_logged_in(): bool { return isset($_SESSION['uid']); }
function require_login(): void { if (!is_logged_in()) { header("Location: /panel/admin/login.php"); exit; } }

function current_user(): ?array {
  if (!is_logged_in()) return null;
  $users = load_users();
  return find_first($users, fn($u) => ($u['id'] ?? '') === ($_SESSION['uid'] ?? ''));
}

function login_attempt(string $username, string $password): bool {
  $users = load_users();
  $u = find_first($users, fn($x) => strtolower((string)($x['username'] ?? '')) === strtolower($username));
  if (!$u) return false;
  $hash = (string)($u['password_hash'] ?? '');
  if (!password_verify($password, $hash)) return false;
  $_SESSION['uid'] = $u['id'];
  $_SESSION['uname'] = $u['username'];
  return true;
}

function logout_now(): void {
  $_SESSION = [];
  if (ini_get("session.use_cookies")) {
    $params = session_get_cookie_params();
    setcookie(session_name(), '', time() - 42000, $params["path"], $params["domain"], $params["secure"], $params["httponly"]);
  }
  session_destroy();
}
