<?php
declare(strict_types=1);
require_once __DIR__ . '/helpers.php';

define('PANEL_ROOT', dirname(__DIR__));
define('DATA_DIR', PANEL_ROOT . '/data');
define('CACHE_DIR', PANEL_ROOT . '/cache');

function path_users(): string   { return DATA_DIR . '/users.json'; }
function path_servers(): string { return DATA_DIR . '/servers.json'; }
function path_clients(): string { return DATA_DIR . '/clients.json'; }

function load_users(): array   { return read_json(path_users()); }
function load_servers(): array { return read_json(path_servers()); }
function load_clients(): array { return read_json(path_clients()); }

function save_users(array $x): void   { write_json(path_users(), $x); }
function save_servers(array $x): void { write_json(path_servers(), $x); }
function save_clients(array $x): void { write_json(path_clients(), $x); }

function init_storage(): void {
  ensure_dir(DATA_DIR);
  ensure_dir(CACHE_DIR);
  if (!file_exists(path_users()))   write_json(path_users(), []);
  if (!file_exists(path_servers())) write_json(path_servers(), []);
  if (!file_exists(path_clients())) write_json(path_clients(), []);
}
