<?php
declare(strict_types=1);

function h(string $s): string { return htmlspecialchars($s, ENT_QUOTES, 'UTF-8'); }
function now(): int { return time(); }

function ensure_dir(string $dir): void { if (!is_dir($dir)) @mkdir($dir, 0755, true); }

function read_json(string $path): array {
  if (!file_exists($path)) return [];
  $raw = file_get_contents($path);
  $data = json_decode($raw ?: '[]', true);
  return is_array($data) ? $data : [];
}

function write_json(string $path, array $data): void {
  $tmp = $path . '.tmp';
  file_put_contents($tmp, json_encode($data, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES));
  rename($tmp, $path);
}

function find_first(array $items, callable $fn): ?array {
  foreach ($items as $it) if ($fn($it)) return $it;
  return null;
}

function update_first(array &$items, callable $fn, callable $mutate): bool {
  foreach ($items as $i => $it) {
    if ($fn($it)) { $items[$i] = $mutate($it); return true; }
  }
  return false;
}

function delete_first(array &$items, callable $fn): bool {
  foreach ($items as $i => $it) {
    if ($fn($it)) { array_splice($items, $i, 1); return true; }
  }
  return false;
}

function http_get(string $url, int $connectTimeout = 8, int $timeout = 25): array {
  $ch = curl_init($url);
  curl_setopt_array($ch, [
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_CONNECTTIMEOUT => $connectTimeout,
    CURLOPT_TIMEOUT => $timeout,
    CURLOPT_FOLLOWLOCATION => false,
    CURLOPT_USERAGENT => "CentralPanel/1.0",
  ]);
  $body = curl_exec($ch);
  $code = (int)curl_getinfo($ch, CURLINFO_HTTP_CODE);
  $err  = curl_error($ch);
  curl_close($ch);
  return [$body, $code, $err];
}
